<?php
// api/get_conversations.php - Get conversations
header('Content-Type: application/json');
require_once '../config.php';

$data = json_decode(file_get_contents('php://input'), true);
$token = $data['token'] ?? '';
$user_id = filter_var($data['user_id'] ?? 0, FILTER_VALIDATE_INT);

if (!$user_id || !$token) {
    http_response_code(400);
    echo json_encode(['error' => 'User ID and token required']);
    exit;
}

$pdo = getDB();
checkRateLimit($pdo, $user_id, 'get_conversations');

if (verifyJWT($token) !== $user_id) {
    http_response_code(401);
    echo json_encode(['error' => 'Invalid token']);
    exit;
}

$stmt = $pdo->prepare("
    SELECT c.id, 
           CASE WHEN c.user1_id = :user_id THEN u2.email ELSE u1.email END AS other_user,
           m.content AS last_message, m.timestamp AS last_time
    FROM conversations c
    LEFT JOIN users u1 ON c.user1_id = u1.id
    LEFT JOIN users u2 ON c.user2_id = u2.id
    LEFT JOIN messages m ON c.id = m.conversation_id
    WHERE (c.user1_id = :user_id OR c.user2_id = :user_id)
    GROUP BY c.id
    ORDER BY MAX(m.timestamp) DESC
");
$stmt->execute(['user_id' => $user_id]);
$convos = $stmt->fetchAll(PDO::FETCH_ASSOC);

http_response_code(200);
echo json_encode(['conversations' => $convos]);
?>