<?php
// api/get_messages.php - Get messages for a conversation
header('Content-Type: application/json');
require_once '../config.php';

$data = json_decode(file_get_contents('php://input'), true);
$token = $data['token'] ?? '';
$user_id = filter_var($data['user_id'] ?? 0, FILTER_VALIDATE_INT);
$convo_id = filter_var($data['convo_id'] ?? 0, FILTER_VALIDATE_INT);

if (!$user_id || !$token || !$convo_id) {
    http_response_code(400);
    echo json_encode(['error' => 'User ID, token, and conversation ID required']);
    exit;
}

$pdo = getDB();
checkRateLimit($pdo, $user_id, 'get_messages');

if (verifyJWT($token) !== $user_id) {
    http_response_code(401);
    echo json_encode(['error' => 'Invalid token']);
    exit;
}

$stmt = $pdo->prepare("SELECT id FROM conversations WHERE id = :id AND (user1_id = :user_id OR user2_id = :user_id)");
$stmt->execute(['id' => $convo_id, 'user_id' => $user_id]);
if (!$stmt->fetch()) {
    http_response_code(403);
    echo json_encode(['error' => 'Access denied']);
    exit;
}

$stmt = $pdo->prepare("SELECT id, sender_id, type, content, timestamp FROM messages WHERE conversation_id = :convo_id ORDER BY timestamp ASC");
$stmt->execute(['convo_id' => $convo_id]);
$messages = $stmt->fetchAll(PDO::FETCH_ASSOC);

http_response_code(200);
echo json_encode(['messages' => $messages]);
?>